/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import junit.framework.AssertionFailedError;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Assert {
    protected Assert() {
    }

    public static void assert(String message, boolean condition) {
        if (!condition) {
            Assert.fail(message);
        }
    }

    public static void assert(boolean condition) {
        Assert.assert(null, condition);
    }

    public static void assertEquals(double expected, double actual, double delta) {
        Assert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(long expected, long actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        if (Math.abs(expected - actual) > delta) {
            Assert.failNotEquals(message, new Double(expected), new Double(actual));
        }
    }

    public static void assertEquals(String message, long expected, long actual) {
        Assert.assertEquals(message, new Long(expected), new Long(actual));
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        Assert.failNotEquals(message, expected, actual);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(null, object);
    }

    public static void assertNotNull(String message, Object object) {
        Assert.assert(message, object != null);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(null, object);
    }

    public static void assertNull(String message, Object object) {
        Assert.assert(message, object == null);
    }

    public static void assertSame(Object expected, Object actual) {
        Assert.assertSame(null, expected, actual);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame(message, expected, actual);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void fail(String message) {
        throw new AssertionFailedError(message);
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = String.valueOf(message) + " ";
        }
        Assert.fail(String.valueOf(formatted) + "expected:<" + expected + "> but was:<" + actual + ">");
    }

    private static void failNotSame(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = String.valueOf(message) + " ";
        }
        Assert.fail(String.valueOf(formatted) + "expected same");
    }
}

